/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   MotoTron Specific Security
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5xx
::   Dependants  :   MotoTronProtocol Archive
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \file MotoTronSpecific.h
    \brief This module handles the security functions for Woodward Product. */

#ifndef __MOTOTRONSPECIFIC_H
#define __MOTOTRONSPECIFIC_H

/*---- INCLUDE FILES --------------------------------------------------------------------------------------*/
#include <typedefn.h>

#include "MotoSecurityItf.h"

/*---- DEFINES --------------------------------------------------------------------------------------------*/

/*---- TYPEDEF --------------------------------------------------------------------------------------------*/
#pragma pack(1)

/*! \enum E_RegisterMotoTronSpecificAttributeMask
\brief Flags used to register specific components of the MotoTronSpecific archive. */
typedef enum
{
    USE_MOTO_SECURITY_PRODUCT_ID = 0x01,   /*!< Selects \ref S_RegisterMotoTronSpecificInfo::eProjectID. Must be selected in conjunction with \ref USE_MOTO_SECURITY_PROJECT_ID. */
    USE_MOTO_SECURITY_PROJECT_ID = 0x02,   /*!< Selects \ref S_RegisterMotoTronSpecificInfo::u4ProductID.  Must be selected in conjunction with \ref USE_MOTO_SECURITY_PRODUCT_ID. */
}E_RegisterMotoTronSpecificAttributeMask;

/*!  \typedef RegisterMotoTronSpecificAttributeMask_U
\brief The member containing the MotoSec archive attribute flags.  See \ref E_RegisterMotoTronSpecificAttributeMask */
typedef uint1 RegisterMotoTronSpecificAttributeMask_U;

/*!  \struct S_RegisterMotoTronSpecificInfo
\brief The structure used to register the MotoTronSpecific archive.  Use S_RegisterMotoTronSpecificInfo::uValidAttributesMask 
to define which components of the archive are to be employed. */
typedef struct
{
/*! Describes which attributes [\ref USE_MOTO_SECURITY_PRODUCT_ID, \ref USE_MOTO_SECURITY_PROJECT_ID] in 
    \ref S_RegisterMotoTronSpecificInfo are to be applied. All possible attributes are described by the 
    \ref E_RegisterMotoTronSpecificAttributeMask enumeration type. */
    RegisterMotoTronSpecificAttributeMask_U    uValidAttributesMask;
/*! Member or type \ref E_ProjectID to specify the desired MotoSecurity project ID.*/
    E_ProjectID eProjectID;
/*! Member or type \ref E_MotoTronProductID to specify the desired MotoSecurity product ID.*/
    uint4 u4ProductID;
}S_RegisterMotoTronSpecificInfo;

/*! Pointer to the Woodward security register info.  See \ref S_RegisterMotoTronSpecificInfoPtr */
typedef const S_RegisterMotoTronSpecificInfo* const S_RegisterMotoTronSpecificInfoPtr;

#pragma pack()
/*---- FUNCTION PROTOTYPES --------------------------------------------------------------------------------*/

NativeError_S RegisterMotoTronSpecificArchive(S_RegisterMotoTronSpecificInfoPtr in_pRegisterMotoTronSpecificInfoPtr);

#endif /* __MOTOTRONSPECIFIC_H */

/*---- END OF FILE ----------------------------------------------------------------------------------------*/

